function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_w_inv_shocks.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(76, 1);
residual(1) = T(34)+T(37)+params(30)*y(132)-y(89);
residual(2) = T(28)*(-T(22))+y(78)*(-(T(33)*params(4)*exp(y(29)*params(4))))+T(22)*y(68)+params(30)*y(134)-y(91);
residual(3) = y(77)*(-(T(31)*params(4)*exp(y(30)*params(4))))+y(73)*y(41)*T(31)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1))+T(38)+params(30)*y(133)-y(90);
residual(4) = T(28)*T(41)+y(81)*(-exp(y(31)))+exp(y(31))*y(80)+params(30)*y(136)-y(93);
residual(5) = y(81)*(-exp(y(32)))+exp(y(32))*y(79)+params(30)*y(135)-y(92);
residual(6) = T(44);
residual(7) = T(46);
residual(8) = T(47);
residual(9) = T(48);
residual(10) = T(51)+params(30)*y(131)*(-exp(y(37)));
residual(11) = T(45)+T(53)+T(55)+params(30)*y(119)*exp(y(34))*params(6)*params(5)*exp(params(5)*y(38))+T(56);
residual(12) = exp(y(39))*y(67);
residual(13) = y(72)*(-params(7))+y(71)+T(35)*y(21)*(-(T(26)*(1-exp(y(11)))))+T(35)*T(26)*y(23);
residual(14) = params(4)*exp(y(30)*(params(4)-1))*T(31)*y(73)+y(72)+T(35)*y(22)*(-(T(26)*(1-params(7))));
residual(15) = T(8)*y(81)+y(64)*(-(params(11)*T(12)*T(57)))+y(63)*(-(params(11)*T(58)*T(59)));
residual(16) = y(68)*(-exp(y(43)))+y(66)*(-(T(5)*T(19)*T(16)*T(61)))+y(65)*(-(T(17)*T(3)*T(16)*T(62)))+y(64)*(-(T(14)*params(11)*T(60)))+exp(y(43))*y(63)+params(30)*y(137)-y(94);
residual(17) = T(20)*y(68)+params(30)*y(115)*(-(T(69)*T(72)))+params(30)*y(116)*(-(T(73)*(T(65)*T(75)*T(76)+T(66)*T(75)*T(78))))+params(30)*y(117)*T(82)+params(30)*y(118)*(-(exp((1-params(3))*y(108))*exp(T(1)*y(112))*params(3)*exp(params(3)*y(44))))+params(30)*y(119)*(-(T(20)*(1-params(10))));
residual(18) = (T(41)-T(22))*T(86)+y(70)*(-(params(1)*T(86)/T(30)))+T(4)*y(69)+y(67)*T(88)+y(66)*T(92)+y(65)*T(94)+y(63)*(-(T(59)*T(96)))+params(30)*y(120)*(-((-(T(86)*T(98)))/(T(28)*T(28))));
residual(19) = (T(41)-T(22))*T(99)+y(70)*T(100)+exp(y(46))*y(68)+params(30)*y(120)*(-((-(T(98)*T(99)))/(T(28)*T(28))));
residual(20) = exp(y(47))*y(66)+T(101);
residual(21) = y(69)*(-(T(24)*T(102)))+exp(y(48))*y(65);
residual(22) = T(104);
residual(23) = y(83)+params(30)*y(127)*(-params(15))+y(67)*(-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))))+y(66)*(-(T(5)*T(19)*T(16)*T(105)))+y(65)*(-(T(17)*T(3)*T(16)*T(106)))+y(63)*(-(T(59)*T(108)))+T(109)*(-params(16))*y(138);
residual(24) = y(84)+params(30)*y(128)*(-params(18))+T(38)+y(73)*(-exp(y(51)))+T(109)*(-params(19))*y(139);
residual(25) = T(28)*(-T(22))+y(85)+params(30)*y(129)*(-params(21))+T(22)*y(68)+T(109)*(-params(22))*y(140);
residual(26) = y(86)+params(30)*y(130)*(-params(24))+T(110)+T(109)*(-params(25))*y(141);
residual(27) = y(87)+T(28)*(-T(40));
residual(28) = y(89);
residual(29) = y(90);
residual(30) = y(91);
residual(31) = y(92);
residual(32) = y(93);
residual(33) = y(94);
residual(34) = T(113)+exp(y(61))*y(88);
residual(35) = T(115)+y(82)+T(120);
residual(36) = exp(y(43))-T(9)^T(10);
residual(37) = exp(y(28))-params(11)*T(12)*T(14);
residual(38) = exp(y(48))-T(3)*T(15)*T(16)*T(17);
residual(39) = exp(y(47))-T(5)*T(16)*T(18)*T(19);
residual(40) = exp(y(39))-exp(T(1)*y(50))*exp(y(13)*params(3))*exp(y(45)*(1-params(3)));
residual(41) = T(23)+exp(y(46))+T(20)+T(21)+T(22)+exp(y(7))*params(6)*exp(params(5)*y(11))-(exp(y(43))+exp(y(13))*(1-params(10)));
residual(42) = T(4)-T(24)*exp(y(48))^T(25);
residual(43) = 1-exp(y(111))*(1+exp(y(110))-params(10));
residual(44) = T(26)-params(1)*T(28)/T(30);
residual(45) = y(40)-exp(y(111))*(exp(y(38))*exp(y(103))+(1-exp(y(38)))*y(104)-params(6)*exp(y(113))*exp(params(5)*y(38)));
residual(46) = y(41)-(y(40)*params(7)+exp(y(111))*(1-params(7))*y(105));
residual(47) = y(41)*params(4)*exp(y(30)*(params(4)-1))*T(31)-exp(y(51));
residual(48) = T(121);
residual(49) = exp(y(34))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(36)));
residual(50) = exp(y(33))-(exp(y(6))*(1-exp((-y(62)))*exp(y(10)))+params(7)*exp(y(35)));
residual(51) = exp(y(36))-((1-params(7))*exp(y(9))+T(31)*exp(y(30)*params(4)));
residual(52) = exp(y(35))-((1-params(7))*exp(y(8))+exp(y(29)*params(4))*T(33));
residual(53) = exp(y(32))-exp(y(7))*exp(y(11));
residual(54) = exp(y(31))-exp(y(6))*exp((-y(62)))*exp(y(10));
residual(55) = T(8)-(exp(y(32))+exp(y(31)));
residual(56) = y(62)-x(it_, 3);
residual(57) = y(50)-(x(it_, 5)+params(15)*y(16)+params(16)*y(24));
residual(58) = y(51)-(x(it_, 2)+params(18)*y(17)+params(19)*y(25));
residual(59) = y(52)-(x(it_, 1)+params(21)*y(18)+params(22)*y(26));
residual(60) = y(53)-(x(it_, 4)+params(24)*y(19)+params(25)*y(27));
residual(61) = y(54);
residual(62) = exp(y(61))-exp(y(10));
residual(63) = y(55)-(y(28)-y(1));
residual(64) = y(56)-(y(30)-y(3));
residual(65) = y(57)-(y(29)-y(2));
residual(66) = y(58)-(y(32)-y(5));
residual(67) = y(59)-(y(31)-y(4));
residual(68) = y(60)-(y(43)-y(12));
lhs = y(95);
rhs = y(127);
residual(69) = lhs - rhs;
lhs = y(96);
rhs = y(128);
residual(70) = lhs - rhs;
lhs = y(97);
rhs = y(129);
residual(71) = lhs - rhs;
lhs = y(98);
rhs = y(130);
residual(72) = lhs - rhs;
lhs = y(99);
rhs = y(16);
residual(73) = lhs - rhs;
lhs = y(100);
rhs = y(17);
residual(74) = lhs - rhs;
lhs = y(101);
rhs = y(18);
residual(75) = lhs - rhs;
lhs = y(102);
rhs = y(19);
residual(76) = lhs - rhs;

end
